package h23.numberplace;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

public class BoardSaver {
	private NumberPlaceGenerator sg;
	private int board[][];
	private int answer[][];
	private boolean enable[][];


	public BoardSaver(NumberPlaceGenerator sg) {
		this.sg = sg;
	}

	public void save(){
		SharedPreferences pref = sg.getSharedPreferences("sg.dat", Context.MODE_PRIVATE);
		Editor editor = pref.edit();
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				editor.putInt("board" + Integer.toString(i) + Integer.toString(j), board[i][j]);
				editor.putInt("answer" + Integer.toString(i) + Integer.toString(j), answer[i][j]);
				editor.putBoolean("enable" + Integer.toString(i) + Integer.toString(j), enable[i][j]);
			}
		}
		editor.putBoolean("existdata", true);
		editor.commit();
	}

	public void setData(int[][] boa, int[][] ans, boolean[][] ena){
		board = boa;
		answer = ans;
		enable = ena;
	}

	public GameData getGameData(){
		GameData gd = new GameData();
		SharedPreferences pref = sg.getSharedPreferences("sg.dat", Context.MODE_PRIVATE);
		if(!pref.getBoolean("existdata", false)){
			return null;
		}

		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				gd.board[i][j] = pref.getInt("board" + Integer.toString(i) + Integer.toString(j), 0);
				gd.answer[i][j] = pref.getInt("answer" + Integer.toString(i) + Integer.toString(j), 0);
				gd.enable[i][j] = pref.getBoolean("enable" + Integer.toString(i) + Integer.toString(j), true);
			}
		}

		return gd;
	}
}
